#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.DlgSelectSpecificities;

#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_AntiseraWorklist : BaseTest 
	{

		private BOL.AntiseraWorklist _tstAW;
		private DataTable _dtAntiseraWorklistTyping;
		private DataTable _dtBloodUnitTest;
		private DataTable _dtBloodUnit;
		private DataTable _dtRack;

		[SetUp]
		protected void SetUp() 
		{			
			this.BaseSetUp();

			if (this.RefreshData)
			{
				//***get the blood unit data
				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", false);
				if (this._dtBloodUnit.Rows.Count == 0)
				{
					DataCreator.CreateBloodUnit(true);
					this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				}

				//***Get the Rack data
				this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Rack WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'" , false);
				if(this._dtRack.Rows.Count == 0)
				{
					DataCreator.CreateQCdRack();
					this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Rack WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'" , true);
				}

				string sql = " SELECT TOP 1 * FROM AntiseraWorklistTyping AWT" +
					" JOIN BloodUnitTest BU ON BU.AntiseraWorklistTypingGuid = AWT.AntiseraWorklistTypingGuid" + 
					" JOIN AntiseraUnitTest AUT ON AUT.AntiseraWorklistTypingGUID = AWT.AntiseraWorklistTypingGUID" +
					" LEFT JOIN RackLot RL on AUT.RackLotGUID = RL.RackLotGUID" +
					" WHERE AWT.AntiseraWorklistGuid IN (" +
					" SELECT AntiseraWorklistGuid FROM AntiseraWorklist" + 
					" WHERE DivisionCode =  '" + UnitTestConfig.TestDivisionCode + "')" +
					" AND AUT.RecordStatusCode = 'A'" +
					" AND RL.RecordStatusCode = 'A'" +
					" AND RL.ControlCellId IS NULL";

				this._dtAntiseraWorklistTyping = UnitTestUtil.RunSQLGetDataTable(sql, false);
				if (this._dtAntiseraWorklistTyping.Rows.Count == 0)
				{
					Save_Pass_AntigenTyping();
					this._dtAntiseraWorklistTyping = UnitTestUtil.RunSQLGetDataTable(sql, true);
				}

				this._dtBloodUnitTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest WHERE AntiseraWorklistTypingGuid = '" + this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid].ToString() + "'", true);

				this.RefreshData = false;

			}

			this._tstAW = new BOL.AntiseraWorklist((Guid)this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistGuid]);
			this._tstAW.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.AntiseraWorklist);
		}

		[Test]
		public void Ctor_Guid_Pass()
		{
			Guid tmpValue = Guid.NewGuid();

			BOL.AntiseraWorklist tmpObject = new BOL.AntiseraWorklist(tmpValue);

			Assert.AreEqual(tmpValue, tmpObject.AntiseraWorklistGuid, "NewGuid-AntiseraWorklistGuid");
			Assert.AreEqual(true, tmpObject.IsNew, "NewGuid-IsNew");

			//Check existing guid code
			tmpValue = (Guid)this._dtAntiseraWorklistTyping.Rows[0][TABLES.AntiseraWorklistTyping.AntiseraWorklistGuid];
			tmpObject = new BOL.AntiseraWorklist(tmpValue);

			Assert.AreEqual(tmpValue, tmpObject.AntiseraWorklistGuid, "ExistingGuid-AntiserWorklistGuid");
			Assert.AreEqual(false, tmpObject.IsNew, "ExistingGuid-IsNew");
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_Guid_Fail()
		{
		}

		[Test]
		public void AntiseraWorklistGuid_Pass()
		{	
			Guid tmpValue = Guid.NewGuid();
			this._tstAW.AntiseraWorklistGuid = tmpValue;

			Assert.AreEqual(tmpValue, this._tstAW.AntiseraWorklistGuid);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void AntiseraWorklistGuid_Fail()
		{			
		}

		[Test]
		public void WorklistName_Pass()
		{			
			string tmpValue = System.DateTime.Now.ToString();

			this._tstAW.WorklistName = tmpValue;
			Assert.AreEqual(tmpValue, this._tstAW.WorklistName);
		}

		[Test]
		public void WorklistName_Fail()
		{
			this._tstAW.WorklistName = string.Empty;
			Assert.AreEqual(true, this._tstAW.IsRuleBroken(BROKEN.WorklistName), "BrokenRule");
		}

		[Test]
		public void RecordStatusCode_Pass()
		{			
			this._tstAW.RecordStatusCode = Common.RecordStatusCode.Inactive;
			Common.RecordStatusCode tmpValue = Common.RecordStatusCode.Active;

			this._tstAW.RecordStatusCode = tmpValue;
			Assert.AreEqual(tmpValue, this._tstAW.RecordStatusCode);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void RecordStatusCode_Fail()
		{
		}

		[Test]
		public void WorklistCreateDate_Pass()
		{
			System.DateTime tmpValue = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this._tstAW.WorklistCreateDate = tmpValue;

			Assert.AreEqual(tmpValue, this._tstAW.WorklistCreateDate, "WorklistCreateDate");
			Assert.AreEqual(false, this._tstAW.IsRuleBroken(BROKEN.WorklistCreateDate), "BrokenRule");
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void WorklistCreateDate_Fail1()
		{
			this._tstAW.WorklistCreateDate = System.DateTime.Now.AddYears(15);
		}

		[Test]
		public void WorklistCreateDate__Fail2()
		{
			this._tstAW.WorklistCreateDate = System.DateTime.MinValue;
			Assert.AreEqual(true, this._tstAW.IsRuleBroken(BROKEN.WorklistCreateDate), "BrokenRule");
		}

		[Test]
		public void TestingMethodCode_Pass()
		{
			this._tstAW.TestingMethodCode = Common.TestingMethod.Tube;
			Common.TestingMethod tmpValue = Common.TestingMethod.Gel;
			this._tstAW.TestingMethodCode = tmpValue;

			Assert.AreEqual(tmpValue, this._tstAW.TestingMethodCode, "TestingMethodCode");
			Assert.AreEqual(false, this._tstAW.IsRuleBroken(BROKEN.TestingMethodCode), "BrokenRule");
		}

		[Test]
		public void TestingMethodCode_Fail()
		{
			this._tstAW.TestingMethodCode = Common.TestingMethod.Unknown;

			Assert.AreEqual(true, this._tstAW.IsRuleBroken(BROKEN.TestingMethodCode), "BrokenRule");
		}

		[Test]
		public void AutomatedInstrument_Pass()
		{
			bool tmpValue = (!this._tstAW.AutomatedInstrument);
			this._tstAW.AutomatedInstrument = tmpValue;

			Assert.AreEqual(tmpValue, this._tstAW.AutomatedInstrument, "AutomatedInstrument");
			Assert.AreEqual(tmpValue, this._tstAW.IsRuleBroken(BROKEN.AutoInstrumentName), "BrokenRule");
		}

		[Test]
		public void AutomatedInstrument_Fail()
		{
			this._tstAW.AutomatedInstrument = true;

			Assert.AreEqual(true, this._tstAW.IsRuleBroken(BROKEN.AutoInstrumentName), "BrokenRule");
		}

		[Test]
		public void AutoInstrumentName_Pass()
		{
			string tmpValue = System.DateTime.Now.ToString();
			this._tstAW.AutoInstrumentName = tmpValue;

			Assert.AreEqual(tmpValue, this._tstAW.AutoInstrumentName, "AutoInstrumentName");
			Assert.AreEqual(false, this._tstAW.IsRuleBroken(BROKEN.AutoInstrumentName), "BrokenRule");

		}

		[Test]
		public void AutoInstrumentName_Fail()
		{
			this._tstAW.AutoInstrumentName = String.Empty;

			Assert.AreEqual(true, this._tstAW.IsRuleBroken(BROKEN.AutoInstrumentName), "BrokenRule");
		}

		[Test]
		public void GetPartiallyCompletedWorklists_Pass()
		{
			DataTable pcWorklists = BOL.AntiseraWorklist.GetPartiallyCompletedWorklists();
			Assert.AreEqual(8,pcWorklists.Columns.Count,"PartialWorklists");
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions)]
		public void GetPartiallyCompletedWorklists_Fail()
		{
		}

		[Test]
		public void GetAntiseraWorklistDetails_Pass()
		{
			Guid antiseraWorklistGuid = Guid.NewGuid();
			Guid antiseraWorklistTypingGuid = Guid.NewGuid();
			this.InsertAntiseraWorklist(antiseraWorklistGuid, antiseraWorklistTypingGuid, Guid.NewGuid(), Guid.NewGuid(), Guid.NewGuid(), Common.OrderableTest.AGC,6,"Anti-C",
				Common.TestingMethod.Gel, Common.ReactivityPhase.AHGandCC,
				null,null,null,"4","","",null,null,null,"2","","",null,null,null,"0","","");
			//
			DataTable details = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(antiseraWorklistGuid);
			Assert.AreEqual(1,details.Rows.Count,"WorklistDetails");
		}

		[Test]
		public void GetAntiseraWorklistDetails_Fail()
		{
			DataTable details = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(Guid.NewGuid());
			Assert.AreEqual(0,details.Rows.Count,"InvalidWorklistGuid");
		}

		[Test]
		public void GetAntiseraWorklistUnits_Pass()
		{
			Guid antiseraWorklistGuid = Guid.NewGuid();
			Guid antiseraWorklistTypingGuid = Guid.NewGuid();
			this.InsertAntiseraWorklist(antiseraWorklistGuid, antiseraWorklistTypingGuid, Guid.NewGuid(), Guid.NewGuid(), Guid.NewGuid(), Common.OrderableTest.AGC,6,"Anti-C",
				Common.TestingMethod.Gel, Common.ReactivityPhase.AHGandCC,
				null,null,null,"4","","",null,null,null,"2","","",null,null,null,"0","","");
			//
			DataTable units = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(antiseraWorklistGuid);
			Assert.AreEqual(1,units.Rows.Count,"WorklistUnits");
		}


		[Test]
		public void GetAntiseraWorklistUnits_Fail()
		{
			DataTable units = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(Guid.NewGuid());
			Assert.AreEqual(0,units.Rows.Count,"InvalidWorklistGuid");
		}

		[Test]
		public void GetTestResultsForAntiseraWorklist_Pass()
		{
			Guid antiseraWorklistGuid = Guid.NewGuid();
			Guid antiseraWorklistTypingGuid = Guid.NewGuid();
			this.InsertAntiseraWorklist(antiseraWorklistGuid, antiseraWorklistTypingGuid, Guid.NewGuid(), Guid.NewGuid(), Guid.NewGuid(), Common.OrderableTest.AGC,6,"Anti-C",
				Common.TestingMethod.Gel, Common.ReactivityPhase.AHGandCC,
				null,null,null,"4","","",null,null,null,"2","","",null,null,null,"0","","");
			//
			DataTable units = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(antiseraWorklistGuid);
			//
			DataTable results = BOL.AntiseraWorklist.GetTestResultsForAntiseraWorklist((Guid)units.Rows[0][TABLES.BloodUnit.BloodUnitGuid],antiseraWorklistTypingGuid);
			Assert.AreEqual(true,results.Rows.Count>0,"WorklistResults");
		}

		[Test]
		public void GetTestResultsForAntiseraWorklist_Fail()
		{
			DataTable results = BOL.AntiseraWorklist.GetTestResultsForAntiseraWorklist(Guid.NewGuid(),Guid.NewGuid());
			Assert.AreEqual(0,results.Rows.Count,"InvalidUnitGuid");
		}

		[Test]
		public void GetAntiseraWorklistTypingTableSchema_Pass()
		{			
			DataTable dtTest = BOL.AntiseraWorklist.GetAntiseraWorklistTypingTableSchema();

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraUnitTest.AntiseraWorklistTypingGuid), "AntiseraWorklistTypingGuid");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraWorklist.AntiseraWorklistGuid), "AntiseraWorklistGuid");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestId), TABLES.OrderableTest.OrderableTestId);
		}
		
		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetAntiseraWorklistTypingTableSchema_Fail()
		{
		}

		[Test]
		public void GetAntiseraUnitTestTableSchema_Pass()
		{			
			DataTable dtTest = BOL.AntiseraWorklist.GetAntiseraUnitTestTableSchema();

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraUnitTest.AntiseraUnitTestGuid), "AntiseraUnitTestGuid");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraUnitTest.AntiseraWorklistTypingGuid), "AntiseraWorklistTypingGuid");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntiseraUnitTest.RackLotGuid), "RackLotGuid");
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetAntiseraUnitTestTableSchema_Fail()
		{
		}

		[Test]
		public void Save_Pass_AntigenTyping()
		{
			//***This makes this method self sustaining
			DataTable dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", false);
			if (dtBloodUnit.Rows.Count == 0)
			{
				DataCreator.CreateBloodUnit(true);
				dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
			}

			//Create new Anti-C reagent to test against.
			DataTable dtReagents = Reagent.InitializeReagentsAndManufacturersTable();
			DataRow drReagent = dtReagents.NewRow();

			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.Reagent.ReagentTypeId] = 6; //Anti-C
			drReagent[TABLES.Reagent.ReagentName] = "Test C Reagent";
			drReagent[TABLES.Reagent.ReceiptDate] = DateTime.Now;
			drReagent[TABLES.Reagent.ReceiptTechId] = UnitTestConfig.User_Technologist;
			drReagent[TABLES.Reagent.InvoiceNumber] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "C"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent[TABLES.Reagent.NumberVialsReceived] = 20;
			drReagent[TABLES.Reagent.NumberVialsAvailable] = 15;
			drReagent[TABLES.Reagent.Comments] = "Unit Test 1705";
			drReagent[TABLES.Reagent.InspectionIndicator] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent[TABLES.ReagentType.ReagentTypeName] = "Anti-C";
			drReagent[TABLES.Reagent.DivisionCode] = UnitTestConfig.TestDivisionCode;
			drReagent[TABLES.Reagent.RecordStatusCode] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Insert new reagent
			BOL.Reagent.InsertNewReagent(dtReagents, BOL.ReagentType.GetReagentTypes(), Common.UpdateFunction.UnitTests);
			//
			Guid buGuid = (Guid)dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			//
			//Now we will insert a new antisera worklist
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(Guid.NewGuid());
			tmpAW.TestingMethodCode = Common.TestingMethod.Gel;
			tmpAW.WorklistCreateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			tmpAW.WorklistName = Environment.UserName;
			//
			DataTable tmpAWT = new DataTable();
			tmpAWT.Columns.Add(TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.AntiseraWorklist.AntiseraWorklistGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.RackGuid,typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.ReactivityPhaseCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.Comments,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.DivisionCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.TestWithId,typeof(int));
			tmpAWT.Columns.Add("RackQCOverrideComment",typeof(string));
			tmpAWT.Columns.Add("ExpiredOverrideComment",typeof(string));
			tmpAWT.Columns.Add("PhaseOverrideComment",typeof(string));
			//
			DataRow drAWT = tmpAWT.NewRow();
			drAWT[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = Guid.NewGuid();
			drAWT[TABLES.AntiseraWorklist.AntiseraWorklistGuid] = tmpAW.AntiseraWorklistGuid;
			drAWT[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGC).ToString();
			drAWT[TABLES.RackLot.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drAWT[TABLES.RackLot.RackGuid] = Guid.Empty;
			drAWT[TABLES.RackLot.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.ISand37).ToString();
			drAWT[TABLES.RackLot.Comments] = "";
			drAWT[TABLES.RackLot.DivisionCode] = UnitTestConfig.TestDivisionCode;
			tmpAWT.Rows.Add(drAWT);
			//
			bool returnVal = tmpAW.Save(tmpAWT,dtBloodUnit,Environment.UserName,Common.UpdateFunction.UnitTests,new Guid[] {buGuid}, Guid.Empty, null, true);
			Assert.IsTrue(returnVal);
		}

		[Test]
		public void Save_Pass_WeakD()
		{
			//Create new Anti-D reagent to test against.
			DataTable dtReagents = Reagent.InitializeReagentsAndManufacturersTable();
			DataRow drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.Reagent.ReagentTypeId] = 52; //Anti-D
			drReagent[TABLES.Reagent.ReagentName] = "Test D Reagent";
			drReagent[TABLES.Reagent.ReceiptDate] = DateTime.Now;
			drReagent[TABLES.Reagent.ReceiptTechId] = UnitTestConfig.User_Technologist;
			drReagent[TABLES.Reagent.InvoiceNumber] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "D"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent[TABLES.Reagent.NumberVialsReceived] = 20;
			drReagent[TABLES.Reagent.NumberVialsAvailable] = 15;
			drReagent[TABLES.Reagent.Comments] = "Unit Test 1708";
			drReagent[TABLES.Reagent.InspectionIndicator] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent[TABLES.ReagentType.ReagentTypeName] = "Anti-D";
			drReagent[TABLES.Reagent.DivisionCode] = UnitTestConfig.TestDivisionCode;
			drReagent[TABLES.Reagent.RecordStatusCode] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Create new Anti-Dc reagent to for Pos control.
			Guid antiDcGuid = Guid.NewGuid();
			drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = antiDcGuid;
			drReagent[TABLES.Reagent.ReagentTypeId] = 53; //Screening Cells
			drReagent[TABLES.Reagent.ReagentName] = "Test Dc Reagent";
			drReagent[TABLES.Reagent.ReceiptDate] = DateTime.Now;
			drReagent[TABLES.Reagent.ReceiptTechId] = UnitTestConfig.User_Technologist;
			drReagent[TABLES.Reagent.InvoiceNumber] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "Dc"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent[TABLES.Reagent.NumberVialsReceived] = 20;
			drReagent[TABLES.Reagent.NumberVialsAvailable] = 15;
			drReagent[TABLES.Reagent.Comments] = "Unit Test 1708";
			drReagent[TABLES.Reagent.InspectionIndicator] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent[TABLES.ReagentType.ReagentTypeName] = "Anti-D Control";
			drReagent[TABLES.Reagent.DivisionCode] = UnitTestConfig.TestDivisionCode;
			drReagent[TABLES.Reagent.RecordStatusCode] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Insert new reagents
			BOL.Reagent.InsertNewReagent(dtReagents, BOL.ReagentType.GetReagentTypes(), Common.UpdateFunction.UnitTests);
			//
			Guid buGuid = (Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			Guid[] buGuids = new Guid[] {buGuid};
			Guid rackGuid = (Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			//
			//Now we will insert a new antisera worklist
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(Guid.NewGuid());
			tmpAW.TestingMethodCode = Common.TestingMethod.Gel;
			tmpAW.WorklistCreateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			tmpAW.WorklistName = Environment.UserName;
			//
			DataTable tmpAWT = new DataTable();
			tmpAWT.Columns.Add(TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.AntiseraWorklist.AntiseraWorklistGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.RackGuid,typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.ReactivityPhaseCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.Comments,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.DivisionCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.TestWithId,typeof(int));
			tmpAWT.Columns.Add("RackQCOverrideComment",typeof(string));
			tmpAWT.Columns.Add("ExpiredOverrideComment",typeof(string));
			tmpAWT.Columns.Add("PhaseOverrideComment",typeof(string));
			//
			DataRow drAWT = tmpAWT.NewRow();
			drAWT[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = Guid.NewGuid();
			drAWT[TABLES.AntiseraWorklist.AntiseraWorklistGuid] = tmpAW.AntiseraWorklistGuid;
			drAWT[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGwD).ToString();
			drAWT[TABLES.RackLot.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drAWT[TABLES.RackLot.RackGuid] = rackGuid;
			drAWT[TABLES.RackLot.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.ThreeSevenandAHG).ToString();
			drAWT[TABLES.RackLot.Comments] = "";
			drAWT[TABLES.RackLot.DivisionCode] = UnitTestConfig.TestDivisionCode;
			tmpAWT.Rows.Add(drAWT);
			//
			//Save the antisera worklist
			bool retValue = tmpAW.Save(tmpAWT,this._dtBloodUnit,Environment.UserName,Common.UpdateFunction.UnitTests,new Guid[] {buGuid}, antiDcGuid,null, false);
			Assert.IsTrue(retValue);
		}

		[Test]
		[ExpectedException(typeof(FormatException))]
		public void Save_Fail()
		{
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(Guid.NewGuid());
			tmpAW.TestingMethodCode = Common.TestingMethod.Gel;
			tmpAW.WorklistCreateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			tmpAW.WorklistName = Environment.UserName;
			//
			DataTable tmpAWT = new DataTable();
			tmpAWT.Columns.Add(TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.AntiseraWorklist.AntiseraWorklistGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.RackGuid,typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.ReactivityPhaseCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.Comments,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.DivisionCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.TestWithId,typeof(int));
			tmpAWT.Columns.Add("RackQCOverrideComment",typeof(string));
			tmpAWT.Columns.Add("ExpiredOverrideComment",typeof(string));
			tmpAWT.Columns.Add("PhaseOverrideComment",typeof(string));
			//
			DataRow drAWT = tmpAWT.NewRow();
			drAWT[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = Guid.NewGuid();
			drAWT[TABLES.AntiseraWorklist.AntiseraWorklistGuid] = tmpAW.AntiseraWorklistGuid;
			drAWT[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGe).ToString();
			drAWT[TABLES.RackLot.Comments] = "";
			drAWT[TABLES.RackLot.DivisionCode] = UnitTestConfig.TestDivisionCode;
			tmpAWT.Rows.Add(drAWT);
			//
			bool retValue = tmpAW.Save(tmpAWT,this._dtBloodUnit,Environment.UserName,Common.UpdateFunction.UnitTests,new Guid[] {Guid.NewGuid()}, Guid.NewGuid(),null, false);
			Assert.IsTrue(retValue);
		}

		[Test]
		public void UpdateTaskStatus_Pass()
		{
			Guid antiseraWorklistGuid = Guid.NewGuid();
			Guid antiseraWorklistTypingGuid = Guid.NewGuid();
			this.InsertAntiseraWorklist(antiseraWorklistGuid, antiseraWorklistTypingGuid, Guid.NewGuid(), Guid.NewGuid(), Guid.NewGuid(), Common.OrderableTest.AGC,6,"Anti-C",
				Common.TestingMethod.Gel, Common.ReactivityPhase.AHGandCC,
				null,null,null,"4","","",null,null,null,"2","","",null,null,null,"0","","");
			//
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(antiseraWorklistGuid);
			//
			bool result = tmpAW.UpdateTaskStatus(Common.TaskStatus.Completed);
			Assert.IsTrue(result);
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void UpdateTaskStatus_Fail()
		{
			Guid antiseraWorklistGuid = Guid.NewGuid();
			Guid antiseraWorklistTypingGuid = Guid.NewGuid();
			this.InsertAntiseraWorklist(antiseraWorklistGuid, antiseraWorklistTypingGuid, Guid.NewGuid(), Guid.NewGuid(), Guid.NewGuid(), Common.OrderableTest.AGC,6,"Anti-C",
				Common.TestingMethod.Gel, Common.ReactivityPhase.AHGandCC,
				null,null,null,"4","","",null,null,null,"2","","",null,null,null,"0","","");
			//
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(antiseraWorklistGuid);
			tmpAW.RowVersion = new byte[8];
			//
			bool result = tmpAW.UpdateTaskStatus(Common.TaskStatus.Completed);
			Assert.IsTrue(result);
		}

		[Test]
		public void GetAntiseraWorklistQCResults_Pass()
		{
			Guid antiseraWorklistGuid = Guid.NewGuid();
			Guid antiseraWorklistTypingGuid = Guid.NewGuid();
			this.InsertAntiseraWorklist(antiseraWorklistGuid, antiseraWorklistTypingGuid, Guid.NewGuid(), Guid.NewGuid(), Guid.NewGuid(), Common.OrderableTest.AGC,6,"Anti-C",
				Common.TestingMethod.Gel, Common.ReactivityPhase.AHGandCC,
				null,null,null,"4","","",null,null,null,"2","","",null,null,null,"0","","");
			//
			DataTable qcResults = BOL.AntiseraWorklist.GetAntiseraWorklistQCResults(antiseraWorklistTypingGuid);
			Assert.AreEqual(true,qcResults.Rows.Count>0,"WorklistQCResults");
		}

		[Test]
		public void GetAntiseraWorklistQCResults_Fail()
		{
			DataTable qcResults = BOL.AntiseraWorklist.GetAntiseraWorklistQCResults(Guid.NewGuid());
			Assert.AreEqual(0,qcResults.Rows.Count,"InvalidWorklistGuid");
		}

		[Test]
		public void GetAntiseraWorklistQCControls_Pass()
		{
			//
			//We're going to create a partially completed AGC worklist.
			//To ensure that this test passes.
			Guid antiseraWorklistGuid = Guid.NewGuid();
			Guid antiseraWorklistTypingGuid = Guid.NewGuid();
			Guid reagentGuid = Guid.NewGuid();
			Guid posControlGuid = Guid.NewGuid();
			Guid negControlGuid = Guid.NewGuid();
			this.InsertAntiseraWorklist(antiseraWorklistGuid, antiseraWorklistTypingGuid, reagentGuid, posControlGuid, negControlGuid, Common.OrderableTest.AGC, 6, "Anti-C",
				Common.TestingMethod.Gel, Common.ReactivityPhase.AHGandCC,
				null,null,null,"4","","",null,null,null,"2","","",null,null,null,"0","","");
			//
			DataTable dt = BOL.AntiseraWorklist.GetAntiseraWorklistQCControls(antiseraWorklistTypingGuid);
			//
			Assert.IsNotNull(dt);
			Assert.AreEqual(12, dt.Columns.Count);
			//
			//Now delete the worklist we just created
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(antiseraWorklistGuid);	//Reset row version
			DataTable tmpAWT = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(antiseraWorklistGuid);
			DataTable dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(antiseraWorklistGuid);	//Load units
			tmpAW.InvalidateAntiseraWorklist(tmpAWT, dtUnits, Common.UpdateFunction.UnitTests, "Unit Test 3106", true);
		}

		[Test]
		public void GetAntiseraWorklistQCControls_Fail()
		{
			Guid antiseraWorklistGuid = Guid.NewGuid();
			Guid antiseraWorklistTypingGuid = Guid.NewGuid();
			this.InsertAntiseraWorklist(antiseraWorklistGuid, antiseraWorklistTypingGuid, Guid.NewGuid(), Guid.NewGuid(), Guid.NewGuid(), Common.OrderableTest.AGC,6,"Anti-C",
				Common.TestingMethod.Gel, Common.ReactivityPhase.AHGandCC,
				null,null,null,"4","","",null,null,null,"2","","",null,null,null,"0","","");
			//
			DataTable dt = BOL.AntiseraWorklist.GetAntiseraWorklistQCControls(Guid.NewGuid());
			Assert.AreEqual(0,dt.Rows.Count,"InvalidWorklistGuid");
		}

		[Test]
		public void InvalidateAntigenTypingTestResults_Pass()
		{
			//
			//We're going to create a partially completed AGC worklist.
			//To ensure that this test passes.
			Guid antiseraWorklistGuid = Guid.NewGuid();
			Guid antiseraWorklistTypingGuid = Guid.NewGuid();
			Guid reagentGuid = Guid.NewGuid();
			Guid posControlGuid = Guid.NewGuid();
			Guid negControlGuid = Guid.NewGuid();
			this.InsertAntiseraWorklist(antiseraWorklistGuid, antiseraWorklistTypingGuid, reagentGuid, posControlGuid, negControlGuid, Common.OrderableTest.AGC, 6, "Anti-C",
				Common.TestingMethod.Gel, Common.ReactivityPhase.AHGandCC,
				null,null,null,"4","","",null,null,null,"2","","",null,null,null,"0","","");
			//
			//Now invalidate the tests! we just created
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(antiseraWorklistGuid);	//Reset row version
			DataTable tmpAWT = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(antiseraWorklistGuid);
			DataTable dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(antiseraWorklistGuid);	//Load units
			bool res = tmpAW.InvalidateAntigenTypingTestResults(tmpAWT.Rows[0], dtUnits, Common.UpdateFunction.UnitTests, "Unit Test 3106");
			Assert.IsTrue(res);
		}

		[Test]
		public void InvalidateAntigenTypingTestResults_ISRT_Pass()
		{
			//
			//We're going to create a partially completed AGC worklist.
			//To ensure that this test passes.
			Guid antiseraWorklistGuid = Guid.NewGuid();
			Guid antiseraWorklistTypingGuid = Guid.NewGuid();
			Guid reagentGuid = Guid.NewGuid();
			Guid posControlGuid = Guid.NewGuid();
			Guid negControlGuid = Guid.NewGuid();
			this.InsertAntiseraWorklist(antiseraWorklistGuid, antiseraWorklistTypingGuid, reagentGuid, posControlGuid, negControlGuid, Common.OrderableTest.AGC, 6, "Anti-C",
				Common.TestingMethod.Gel, Common.ReactivityPhase.ISandRT,
				"4","2",null,null,null,"","2","2",null,null,null,"","0","0",null,null,null,"");
			//
			//Now invalidate the tests! we just created
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(antiseraWorklistGuid);	//Reset row version
			DataTable tmpAWT = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(antiseraWorklistGuid);
			//for 100% coverage make clear RackGuid
			tmpAWT.Rows[0][TABLES.RackLot.RackGuid] = Guid.Empty;
			//
			DataTable dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(antiseraWorklistGuid);	//Load units
			bool res = tmpAW.InvalidateAntigenTypingTestResults(tmpAWT.Rows[0], dtUnits, Common.UpdateFunction.UnitTests, "Unit Test 7106");
			Assert.IsTrue(res);
		}

		[Test]
		public void InvalidateAntigenTypingTestResults_IS37_Pass()
		{
			//
			//We're going to create a partially completed AGC worklist.
			//To ensure that this test passes.
			Guid antiseraWorklistGuid = Guid.NewGuid();
			Guid antiseraWorklistTypingGuid = Guid.NewGuid();
			Guid reagentGuid = Guid.NewGuid();
			Guid posControlGuid = Guid.NewGuid();
			Guid negControlGuid = Guid.NewGuid();
			this.InsertAntiseraWorklist(antiseraWorklistGuid, antiseraWorklistTypingGuid, reagentGuid, posControlGuid, negControlGuid, Common.OrderableTest.AGC, 6, "Anti-C",
				Common.TestingMethod.Gel, Common.ReactivityPhase.ISand37,
				"4",null,"4",null,null,"","2",null,"2",null,null,"","0",null,"0",null,null,"");			
			//
			//Now invalidate the tests! we just created
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(antiseraWorklistGuid);	//Reset row version
			DataTable tmpAWT = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(antiseraWorklistGuid);
			DataTable dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(antiseraWorklistGuid);	//Load units
			bool res = tmpAW.InvalidateAntigenTypingTestResults(tmpAWT.Rows[0], dtUnits, Common.UpdateFunction.UnitTests, "Unit Test 7107");
			Assert.IsTrue(res);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InvalidateAntigenTypingTestResults_Fail()
		{
		}

		[Test]
		public void InvalidateWeakDTestResults_Pass()
		{
		    DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			//
			Guid buGuid = Guid.NewGuid();
			Guid bloodProductGuid = DataCreator.GetRandomRecordGuid(TABLES.BloodProduct.TableName, "ProductTypeCode = 'E002' AND ProductCodeIndicator = 0 AND RecordStatusCode = 'A'");
			DataCreator.CreateBloodUnit(buGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, true);
			Guid[] buGuids = new Guid[] {buGuid};
			DataTable dtUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE BloodUnitGuid = '" + buGuid.ToString() + "'");
			//
			Guid rackGuid = (Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			//
			//Create new Anti-D reagent to test against.
			DataTable dtReagents = Reagent.InitializeReagentsAndManufacturersTable();
			DataRow drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = Guid.NewGuid();
			drReagent[TABLES.Reagent.ReagentTypeId] = 52; //Anti-D
			drReagent[TABLES.Reagent.ReagentName] = "Test D Reagent";
			drReagent[TABLES.Reagent.ReceiptDate] = DateTime.Now;
			drReagent[TABLES.Reagent.ReceiptTechId] = UnitTestConfig.User_Technologist;
			drReagent[TABLES.Reagent.InvoiceNumber] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "D"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent[TABLES.Reagent.NumberVialsReceived] = 20;
			drReagent[TABLES.Reagent.NumberVialsAvailable] = 15;
			drReagent[TABLES.Reagent.Comments] = "Unit Test 248";
			drReagent[TABLES.Reagent.InspectionIndicator] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent[TABLES.ReagentType.ReagentTypeName] = "Anti-D";
			drReagent[TABLES.Reagent.DivisionCode] = UnitTestConfig.TestDivisionCode;
			drReagent[TABLES.Reagent.RecordStatusCode] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Create new Anti-Dc reagent to for Pos control.
			Guid antiDcGuid = Guid.NewGuid();
			drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = antiDcGuid;
			drReagent[TABLES.Reagent.ReagentTypeId] = 53; //Screening Cells
			drReagent[TABLES.Reagent.ReagentName] = "Test Dc Reagent";
			drReagent[TABLES.Reagent.ReceiptDate] = DateTime.Now;
			drReagent[TABLES.Reagent.ReceiptTechId] = UnitTestConfig.User_Technologist;
			drReagent[TABLES.Reagent.InvoiceNumber] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "Dc"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent[TABLES.Reagent.NumberVialsReceived] = 20;
			drReagent[TABLES.Reagent.NumberVialsAvailable] = 15;
			drReagent[TABLES.Reagent.Comments] = "Unit Test 248";
			drReagent[TABLES.Reagent.InspectionIndicator] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent[TABLES.ReagentType.ReagentTypeName] = "Anti-D Control";
			drReagent[TABLES.Reagent.DivisionCode] = UnitTestConfig.TestDivisionCode;
			drReagent[TABLES.Reagent.RecordStatusCode] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Insert new reagents
			BOL.Reagent.InsertNewReagent(dtReagents, BOL.ReagentType.GetReagentTypes(), Common.UpdateFunction.UnitTests);
			//We also have to ensure that Anti-D Control is part of daily QC - for 100% coverage
			UnitTestUtil.RunSQL("UPDATE ReagentTestParameter SET DailyUseIndicator = 1 WHERE ReagentTypeId = 53 and RecordStatusCode = 'A' and DivisionCode = '"+UnitTestConfig.TestDivisionCode+"'");
			//
			//Now we will insert a new antisera worklist
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(Guid.NewGuid());
			tmpAW.TestingMethodCode = Common.TestingMethod.Gel;
			tmpAW.WorklistCreateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			tmpAW.WorklistName = Environment.UserName;
			//
			DataTable tmpAWT = new DataTable();
			tmpAWT.Columns.Add(TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.AntiseraWorklist.AntiseraWorklistGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.RackGuid,typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.ReactivityPhaseCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.Comments,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.DivisionCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.TestWithId,typeof(int));
			tmpAWT.Columns.Add("RackQCOverrideComment",typeof(string));
			tmpAWT.Columns.Add("ExpiredOverrideComment",typeof(string));
			tmpAWT.Columns.Add("PhaseOverrideComment",typeof(string));
			//
			DataRow drAWT = tmpAWT.NewRow();
			drAWT[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = Guid.NewGuid();
			drAWT[TABLES.AntiseraWorklist.AntiseraWorklistGuid] = tmpAW.AntiseraWorklistGuid;
			drAWT[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(Common.OrderableTest.AGwD).ToString();
			drAWT[TABLES.RackLot.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drAWT[TABLES.RackLot.RackGuid] = rackGuid;
			drAWT[TABLES.RackLot.ReactivityPhaseCode] = Convert.ToInt32(Common.ReactivityPhase.ThreeSevenandAHG).ToString();
			drAWT[TABLES.RackLot.Comments] = "";
			drAWT[TABLES.RackLot.DivisionCode] = UnitTestConfig.TestDivisionCode;
			drAWT["RackQCOverrideComment"] = "Unit Test 248";
			drAWT["ExpiredOverrideComment"] = "Unit Test 248";
			drAWT["PhaseOverrideComment"] = "Unit Test 248";
			tmpAWT.Rows.Add(drAWT);
			//
			//Save the antisera worklist
			tmpAW.Save(tmpAWT,dtUnit,Environment.UserName,Common.UpdateFunction.UnitTests,new Guid[] {buGuid}, antiDcGuid,"Unit Test", true);
			//
			//Now we need to load the saved antisera worklist, complete some tests and save again.
			BOL.AntiseraWorklist aw = new BOL.AntiseraWorklist(tmpAW.AntiseraWorklistGuid);
			DataTable dtAWT = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(tmpAW.AntiseraWorklistGuid);
			DataTable dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(tmpAW.AntiseraWorklistGuid);
			//
			DataRow drRackLot = dtAWT.Rows[0];
			DataRow drUnit = dtUnits.Rows[0];
			DataRow drDReagent = dtReagents.Rows[0];
			DataRow drDcReagent = dtReagents.Rows[1];
			//
			//Now create WeakD grid table
			DataTable dtWD = new DataTable("WeakD");
			//
			dtWD.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtWD.Columns.Add(TABLES.ExceptionUnitIssue.UnitId, typeof(string));
			dtWD.Columns.Add(TABLES.BloodProduct.ProductName, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.D37,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.Dc37,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DAHG,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DcAHG,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DCC, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.DcCC, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.Interp, typeof(string));			
			dtWD.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dtWD.Columns.Add(TABLES.ValidRhResult.SystemInterp, typeof(string));
			dtWD.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.AntiDReagentGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DControlReagentGuid, typeof(Guid));
			dtWD.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtWD.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtWD.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.D37Guid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.Dc37Guid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DAHGGuid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DcAHGGuid,typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DCCGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.DcCCGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));
			dtWD.Columns.Add(ARTIFICIAL.D37RowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.Dc37RowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DAHGRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DcAHGRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DCCRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.DcCCRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtWD.Columns.Add(ARTIFICIAL.D37Save, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.Dc37Save, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DAHGSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DcAHGSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DCCSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.DcCCSave, typeof(bool));
			dtWD.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dtWD.Columns.Add(TABLES.BloodUnitStatus.QuarantineIndicator, typeof(bool));
			dtWD.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtWD.Columns.Add(TABLES.Rack.RackGuid, typeof(Guid));
			dtWD.Columns.Add(TABLES.ExceptionQc.ExceptionComment, typeof(string));
			//
			DataRow dr = dtWD.NewRow();
			dr[ARTIFICIAL.Indicator] = "";
			dr[TABLES.ExceptionUnitIssue.UnitId] = drUnit[TABLES.BloodUnit.EyeReadableUnitId];
			dr[TABLES.BloodProduct.ProductName] = drUnit[TABLES.BloodProduct.ProductShortName];
			dr[ARTIFICIAL.D37] = "4";
			dr[ARTIFICIAL.Dc37] = "0";
			dr[ARTIFICIAL.DAHG] = "";
			dr[ARTIFICIAL.DcAHG] = "";
			dr[ARTIFICIAL.DCC] = "";
			dr[ARTIFICIAL.DcCC] = "";
			dr[ARTIFICIAL.Interp] = "";
			dr[ARTIFICIAL.Comment] = "Unit Testing";
			dr[TABLES.ValidRhResult.SystemInterp] = "";
			dr[TABLES.BloodUnit.BloodUnitGuid] = drUnit[TABLES.BloodUnit.BloodUnitGuid];
			dr[ARTIFICIAL.AntiDReagentGuid] = drDReagent[TABLES.Reagent.ReagentGuid];
			dr[ARTIFICIAL.DControlReagentGuid] = drDcReagent[TABLES.Reagent.ReagentGuid];
			dr[TABLES.ReactivityPhase.ReactivityPhaseCode] = drRackLot[TABLES.RackLot.ReactivityPhaseCode];
			dr[TABLES.OrderableTest.OrderableTestId] = drRackLot[TABLES.OrderableTest.OrderableTestId];
			dr[ARTIFICIAL.IndicatorMessage] = "";
			dr[ARTIFICIAL.PartiallyCompleted] = true;
			dr[ARTIFICIAL.D37Guid] = Guid.Empty;
			dr[ARTIFICIAL.Dc37Guid] = Guid.Empty;
			dr[ARTIFICIAL.DAHGGuid] = Guid.Empty;
			dr[ARTIFICIAL.DcAHGGuid] = Guid.Empty;
			dr[ARTIFICIAL.DCCGuid] = Guid.Empty;
			dr[ARTIFICIAL.DcCCGuid] = Guid.Empty;
			dr[ARTIFICIAL.InterpGuid] = Guid.Empty;
			dr[ARTIFICIAL.D37RowVersion] = DBNull.Value;
			dr[ARTIFICIAL.Dc37RowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DAHGRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DcAHGRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DCCRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.DcCCRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.D37Save] = true;
			dr[ARTIFICIAL.Dc37Save] = true;
			dr[ARTIFICIAL.DAHGSave] = false;
			dr[ARTIFICIAL.DcAHGSave] = false;
			dr[ARTIFICIAL.DCCSave] = false;
			dr[ARTIFICIAL.DcCCSave] = false;
			dr[ARTIFICIAL.InterpSave] = false;
			dr[TABLES.BloodUnitStatus.QuarantineIndicator] = false;
			dr[TABLES.VamcDivision.DivisionCode] = drRackLot[TABLES.RackLot.DivisionCode].ToString();
			dr[TABLES.Rack.RackGuid] = drRackLot[TABLES.RackLot.RackGuid];
			//
			DataTable results = BOL.AntiseraWorklist.GetTestResultsForAntiseraWorklist((Guid)drUnit[TABLES.BloodUnit.BloodUnitGuid],(Guid)drRackLot[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid]);
			//
			DataTable testTypes = BOL.BloodTestType.GetBloodTestTypes(drRackLot[TABLES.OrderableTest.OrderableTestId].ToString());
			//
			foreach(DataRow result in results.Rows)
			{
				DataRow[] relevantTest = testTypes.Select(TABLES.BloodTestType.BloodTestTypeId+" = '" + result[TABLES.BloodTestType.BloodTestTypeId].ToString() + "'");
				if (relevantTest.Length >0)
				{
					string bloodTestType = relevantTest[0][TABLES.BloodTestType.BloodTestName].ToString();
					if (bloodTestType.IndexOf("wD 37") > -1)
					{
						dr[ARTIFICIAL.D37Guid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.D37RowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("D Control 37") > -1)
					{
						dr[ARTIFICIAL.Dc37Guid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.Dc37RowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("wD AHG") > -1)
					{
						dr[ARTIFICIAL.DAHGGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DAHGRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("D Control AHG") > -1)
					{
						dr[ARTIFICIAL.DcAHGGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DcAHGRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("wD CC") > -1)
					{
						dr[ARTIFICIAL.DCCGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DCCRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf("D Control CC") > -1)
					{
						dr[ARTIFICIAL.DcCCGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.DcCCRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf(ARTIFICIAL.Interp) > -1)
					{
						dr[ARTIFICIAL.InterpGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.InterpRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
				}
			}
			//
			dtWD.Rows.Add(dr);
			//
			ArrayList workloadProcessIds = new ArrayList(1);
			workloadProcessIds.Add(Common.WorkloadProcessID.Unknown);
			BOL.BloodUnitTest.SaveWeakDBloodUnitTests((Guid)drRackLot[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid],tmpAW,dtWD, Common.UpdateFunction.UC041FrmRecordPhenotypeResults, workloadProcessIds, buGuids);  
			//
			bool retValue = tmpAW.InvalidateWeakDTestResults(dtAWT.Rows[0], dtUnits, Common.UpdateFunction.UnitTests, "Unit Test 248");
			Assert.IsTrue(retValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InvalidateWeakDTestResults_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Pass()
		{
			
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void LoadDataRowFromThis_Fail()
		{
			DataRow dr = new DataTable().NewRow();
			dr = this._tstAW.LoadDataRowFromThis(dr);
		}

		[Test]
		public void InvalidateAntiseraWorklist_Pass()
		{
			//
			//We're going to create a partially completed AGC worklist.
			//To ensure that this test passes.
			Guid antiseraWorklistGuid = Guid.NewGuid();
			Guid antiseraWorklistTypingGuid = Guid.NewGuid();
			Guid reagentGuid = Guid.NewGuid();
			Guid posControlGuid = Guid.NewGuid();
			Guid negControlGuid = Guid.NewGuid();
			this.InsertAntiseraWorklist(antiseraWorklistGuid, antiseraWorklistTypingGuid, reagentGuid, posControlGuid, negControlGuid, Common.OrderableTest.AGC, 6, "Anti-C",
				Common.TestingMethod.Gel, Common.ReactivityPhase.ISand37,
				"4",null,"4",null,null,"","2",null,"2",null,null,"","0",null,"0",null,null,"");			
			//
			//Now invalidate the tests! we just created
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(antiseraWorklistGuid);	//Reset row version
			DataTable tmpAWT = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(antiseraWorklistGuid);
			DataTable dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(antiseraWorklistGuid);	//Load units
			bool res = tmpAW.InvalidateAntiseraWorklist(tmpAWT, dtUnits, Common.UpdateFunction.UnitTests, "Unit Test 7352",true);
			Assert.IsTrue(res);

		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void InvalidateAntiseraWorklist_Fail()
		{
			//
			//We're going to create a partially completed AGC worklist.
			//To ensure that this test passes.
			Guid antiseraWorklistGuid = Guid.NewGuid();
			Guid antiseraWorklistTypingGuid = Guid.NewGuid();
			Guid reagentGuid = Guid.NewGuid();
			Guid posControlGuid = Guid.NewGuid();
			Guid negControlGuid = Guid.NewGuid();
			this.InsertAntiseraWorklist(antiseraWorklistGuid, antiseraWorklistTypingGuid, reagentGuid, posControlGuid, negControlGuid, Common.OrderableTest.AGC, 6, "Anti-C",
				Common.TestingMethod.Gel, Common.ReactivityPhase.ISand37,
				"4",null,"4",null,null,"","2",null,"2",null,null,"","0",null,"0",null,null,"");			
			//
			//Now invalidate the tests! we just created
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(antiseraWorklistGuid);	//Reset row version
			tmpAW.RowVersion = new byte[8];
			DataTable tmpAWT = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(antiseraWorklistGuid);
			DataTable dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(antiseraWorklistGuid);	//Load units
			bool res = tmpAW.InvalidateAntiseraWorklist(tmpAWT, dtUnits, Common.UpdateFunction.UnitTests, "Unit Test 7353",true);
			Assert.IsTrue(res);
		}

		#region Helper Methods

		private void InsertAntiseraWorklist(Guid antiseraWorklistGuid, Guid antiseraWorklistTypingGuid, Guid reagentGuid, Guid posControlGuid, Guid negControlGuid, Common.OrderableTest orderableTest, int reagentTypeId, string reagentTypeName, Common.TestingMethod testingMethod, Common.ReactivityPhase reactivityPhase, 
			string iS, string rt, string three7, string ahg, string cc, string interp,
			string posis, string posrt, string pos37, string posahg, string poscc, string posinterp,
			string negis, string negrt, string neg37, string negahg, string negcc, string neginterp)
		{
			//Create new reagent to test against.
			DataTable dtReagents = Reagent.InitializeReagentsAndManufacturersTable();
			DataRow drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = reagentGuid;
			drReagent[TABLES.Reagent.ReagentTypeId] = reagentTypeId;
			drReagent[TABLES.Reagent.ReagentName] = "Test Reagent";
			drReagent[TABLES.Reagent.ReceiptDate] = DateTime.Now;
			drReagent[TABLES.Reagent.ReceiptTechId] = UnitTestConfig.User_Technologist;
			drReagent[TABLES.Reagent.InvoiceNumber] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent[TABLES.Reagent.NumberVialsReceived] = 20;
			drReagent[TABLES.Reagent.NumberVialsAvailable] = 15;
			drReagent[TABLES.Reagent.Comments] = "Unit Test";
			drReagent[TABLES.Reagent.InspectionIndicator] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent[TABLES.ReagentType.ReagentTypeName] = reagentTypeName;
			drReagent[TABLES.Reagent.DivisionCode] = UnitTestConfig.TestDivisionCode;
			drReagent[TABLES.Reagent.RecordStatusCode] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Create new Screening Cells reagent to for Pos control.
			drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = posControlGuid;
			drReagent[TABLES.Reagent.ReagentTypeId] = 63; //Screening Cells
			drReagent[TABLES.Reagent.ReagentName] = "Test SC Reagent";
			drReagent[TABLES.Reagent.ReceiptDate] = DateTime.Now;
			drReagent[TABLES.Reagent.ReceiptTechId] = UnitTestConfig.User_Technologist;
			drReagent[TABLES.Reagent.InvoiceNumber] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = "SC"+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent[TABLES.Reagent.NumberVialsReceived] = 20;
			drReagent[TABLES.Reagent.NumberVialsAvailable] = 15;
			drReagent[TABLES.Reagent.Comments] = "Unit Test";
			drReagent[TABLES.Reagent.InspectionIndicator] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent[TABLES.ReagentType.ReagentTypeName] = "Screening Cells";
			drReagent[TABLES.Reagent.DivisionCode] = UnitTestConfig.TestDivisionCode;
			drReagent[TABLES.Reagent.RecordStatusCode] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Create new Check Cells reagent to for Neg control.
			drReagent = dtReagents.NewRow();
			drReagent[TABLES.Reagent.ReagentGuid] = negControlGuid;
			drReagent[TABLES.Reagent.ReagentTypeId] = 56; //Check Cells
			drReagent[TABLES.Reagent.ReagentName] = "Test CC Reagent";
			drReagent[TABLES.Reagent.ReceiptDate] = DateTime.Now;
			drReagent[TABLES.Reagent.ReceiptTechId] = UnitTestConfig.User_Technologist;
			drReagent[TABLES.Reagent.InvoiceNumber] = DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotNumber] = ARTIFICIAL.CC+DateTime.Now.ToString();
			drReagent[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddYears(3);
			drReagent[TABLES.Reagent.NumberVialsReceived] = 20;
			drReagent[TABLES.Reagent.NumberVialsAvailable] = 15;
			drReagent[TABLES.Reagent.Comments] = "Unit Test";
			drReagent[TABLES.Reagent.InspectionIndicator] = true;
			drReagent[TABLES.Reagent.ReagentManufacturerName] = "Test Manufacturer Name";
			drReagent[TABLES.ReagentType.ReagentTypeName] = "Check Cells";
			drReagent[TABLES.Reagent.DivisionCode] = UnitTestConfig.TestDivisionCode;
			drReagent[TABLES.Reagent.RecordStatusCode] = Common.RecordStatusCode.Active;
			dtReagents.Rows.Add(drReagent);
			//
			//Insert new reagents
			BOL.Reagent.InsertNewReagent(dtReagents, BOL.ReagentType.GetReagentTypes(), Common.UpdateFunction.UnitTests);
			//
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			//
			Guid buGuid = Guid.NewGuid();
			Guid bloodProductGuid = DataCreator.GetRandomRecordGuid(TABLES.BloodProduct.TableName, "ProductTypeCode = 'E002' AND ProductCodeIndicator = 0 AND RecordStatusCode = 'A'");
			DataCreator.CreateBloodUnit(buGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, true);
			Guid[] buGuids = new Guid[] {buGuid};
			DataTable dtUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE BloodUnitGuid = '" + buGuid.ToString() + "'");
			DataRow drUnit = dtUnit.Rows[0];
			//
			Guid rackGuid = (Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			//
			//Now we will insert a new antisera worklist
			BOL.AntiseraWorklist tmpAW = new BOL.AntiseraWorklist(antiseraWorklistGuid);
			tmpAW.TestingMethodCode = testingMethod;
			tmpAW.WorklistCreateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			tmpAW.WorklistName = Environment.UserName;
			//
			DataTable tmpAWT = new DataTable();
			tmpAWT.Columns.Add(TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.AntiseraWorklist.AntiseraWorklistGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.RackGuid,typeof(Guid));
			tmpAWT.Columns.Add(TABLES.RackLot.ReactivityPhaseCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.Comments,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.DivisionCode,typeof(string));
			tmpAWT.Columns.Add(TABLES.RackLot.TestWithId,typeof(int));
			tmpAWT.Columns.Add("RackQCOverrideComment",typeof(string));
			tmpAWT.Columns.Add("ExpiredOverrideComment",typeof(string));
			tmpAWT.Columns.Add("PhaseOverrideComment",typeof(string));
			//
			DataRow drAWT = tmpAWT.NewRow();
			drAWT[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = antiseraWorklistTypingGuid;
			drAWT[TABLES.AntiseraWorklist.AntiseraWorklistGuid] = antiseraWorklistGuid;
			drAWT[TABLES.OrderableTest.OrderableTestId] = Convert.ToInt32(orderableTest).ToString();
			drAWT[TABLES.RackLot.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drAWT[TABLES.RackLot.RackGuid] = rackGuid;
			drAWT[TABLES.RackLot.ReactivityPhaseCode] = Convert.ToInt32(reactivityPhase).ToString();
			drAWT[TABLES.RackLot.Comments] = "";
			drAWT[TABLES.RackLot.DivisionCode] = UnitTestConfig.TestDivisionCode;
			tmpAWT.Rows.Add(drAWT);
			//
			//Save the antisera worklist
			tmpAW.Save(tmpAWT,dtUnit,Environment.UserName,Common.UpdateFunction.UnitTests,new Guid[] {buGuid}, Guid.Empty, null, true);
			//
			//Now create AG grid table
			DataTable dtAG = new DataTable("Phenotype");
			//
			dtAG.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtAG.Columns.Add(TABLES.ExceptionUnitIssue.UnitId, typeof(string));
			dtAG.Columns.Add(TABLES.BloodProduct.ProductName, typeof(string));
			dtAG.Columns.Add(ARTIFICIAL.IS,typeof(string));
			dtAG.Columns.Add(ARTIFICIAL.RT,typeof(string));
			dtAG.Columns.Add(ARTIFICIAL.C37,typeof(string));
			dtAG.Columns.Add(ARTIFICIAL.AHG,typeof(string));
			dtAG.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtAG.Columns.Add(ARTIFICIAL.Interp, typeof(string));			
			dtAG.Columns.Add(ARTIFICIAL.Comment, typeof(string));
			dtAG.Columns.Add(TABLES.ValidRhResult.SystemInterp, typeof(string));
			dtAG.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtAG.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtAG.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtAG.Columns.Add(TABLES.OrderableTest.OrderableTestId,typeof(string));
			dtAG.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtAG.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtAG.Columns.Add(ARTIFICIAL.ISGuid,typeof(Guid));
			dtAG.Columns.Add(ARTIFICIAL.RTGuid,typeof(Guid));
			dtAG.Columns.Add(ARTIFICIAL.C37Guid,typeof(Guid));
			dtAG.Columns.Add(ARTIFICIAL.AHGGuid,typeof(Guid));
			dtAG.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtAG.Columns.Add(ARTIFICIAL.InterpGuid, typeof(Guid));
			dtAG.Columns.Add(ARTIFICIAL.ISRowVersion,typeof(byte[]));
			dtAG.Columns.Add(ARTIFICIAL.RTRowVersion,typeof(byte[]));
			dtAG.Columns.Add(ARTIFICIAL.C37RowVersion,typeof(byte[]));
			dtAG.Columns.Add(ARTIFICIAL.AHGRowVersion,typeof(byte[]));
			dtAG.Columns.Add(ARTIFICIAL.CCRowVersion,typeof(byte[]));
			dtAG.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtAG.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtAG.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dtAG.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtAG.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtAG.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtAG.Columns.Add(ARTIFICIAL.InterpSave, typeof(bool));
			dtAG.Columns.Add(TABLES.BloodUnitStatus.QuarantineIndicator, typeof(bool));
			dtAG.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtAG.Columns.Add(TABLES.ExceptionQc.ExceptionComment, typeof(string));
			//
			DataRow dr = dtAG.NewRow();
			dr[ARTIFICIAL.Indicator] = "";
			dr[TABLES.ExceptionUnitIssue.UnitId] = drUnit[TABLES.BloodUnit.EyeReadableUnitId];
			dr[TABLES.BloodProduct.ProductName] = drUnit[TABLES.BloodProduct.ProductShortName];
			if (iS != null)	dr[ARTIFICIAL.IS] = iS;
			if (rt != null) dr[ARTIFICIAL.RT] = rt;
			if (three7 != null) dr[ARTIFICIAL.C37] = three7;
			if (ahg != null) dr[ARTIFICIAL.AHG] = ahg;
			if (cc != null) dr[ARTIFICIAL.CC] = cc;
			if (interp != null) dr[ARTIFICIAL.Interp] = interp;
			dr[ARTIFICIAL.Comment] = "Unit Testing";
			dr[TABLES.ValidRhResult.SystemInterp] = "";
			dr[TABLES.BloodUnit.BloodUnitGuid] = drUnit[TABLES.BloodUnit.BloodUnitGuid];
			dr[TABLES.Reagent.ReagentGuid] = reagentGuid;
			dr[TABLES.ReactivityPhase.ReactivityPhaseCode] = drAWT[TABLES.ReactivityPhase.ReactivityPhaseCode];
			dr[ARTIFICIAL.IndicatorMessage] = "";
			dr[ARTIFICIAL.PartiallyCompleted] = true;
			dr[ARTIFICIAL.ISGuid] = Guid.Empty;
			dr[ARTIFICIAL.RTGuid] = Guid.Empty;
			dr[ARTIFICIAL.C37Guid] = Guid.Empty;
			dr[ARTIFICIAL.AHGGuid] = Guid.Empty;
			dr[ARTIFICIAL.CCGuid] = Guid.Empty;
			dr[ARTIFICIAL.InterpGuid] = Guid.Empty;
			dr[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			dr[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			dr[ARTIFICIAL.ISSave] = (iS != null) ? true : false;
			dr[ARTIFICIAL.RTSave] = (rt != null) ? true : false;
			dr[ARTIFICIAL.C37Save] = (three7 != null) ? true : false;
			dr[ARTIFICIAL.AHGSave] = (ahg != null) ? true : false;
			dr[ARTIFICIAL.CCSave] = (cc != null) ? true : false;
			dr[ARTIFICIAL.InterpSave] = (interp != null) ? true : false;
			dr[TABLES.BloodUnitStatus.QuarantineIndicator] = false;
			dr[TABLES.ExceptionQc.ExceptionComment] = DBNull.Value;
			//
			DataTable results = BOL.AntiseraWorklist.GetTestResultsForAntiseraWorklist(buGuid,antiseraWorklistTypingGuid);
			//
			DataTable testTypes = BOL.BloodTestType.GetBloodTestTypes(drAWT[TABLES.OrderableTest.OrderableTestId].ToString());
			//
			foreach(DataRow result in results.Rows)
			{
				DataRow[] relevantTest = testTypes.Select(TABLES.BloodTestType.BloodTestTypeId+" = '" + result[TABLES.BloodTestType.BloodTestTypeId].ToString() + "'");
				if (relevantTest.Length >0)
				{
					string bloodTestType = relevantTest[0][TABLES.BloodTestType.BloodTestName].ToString();
					if (bloodTestType.IndexOf(ARTIFICIAL.IS) > -1)
					{
						dr[ARTIFICIAL.ISGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.ISRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					if (bloodTestType.IndexOf(ARTIFICIAL.RT) > -1)
					{
						dr[ARTIFICIAL.RTGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.RTRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					if (bloodTestType.IndexOf(ARTIFICIAL.C37) > -1)
					{
						dr[ARTIFICIAL.C37Guid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.C37RowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					if (bloodTestType.IndexOf(ARTIFICIAL.AHG) > -1)
					{
						dr[ARTIFICIAL.AHGGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.AHGRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf(ARTIFICIAL.CC) > -1)
					{
						dr[ARTIFICIAL.CCGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.CCRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
					else if (bloodTestType.IndexOf(ARTIFICIAL.Interp) > -1)
					{
						dr[ARTIFICIAL.InterpGuid] = result[TABLES.BloodUnitTest.BloodUnitTestGuid];
						dr[ARTIFICIAL.InterpRowVersion] = result[TABLES.BloodUnitTest.RowVersion];
					}
				}
			}
			//
			dtAG.Rows.Add(dr);
			//
			//Now create control table
			DataTable dtWorklistQCResults = BOL.AntiseraWorklist.GetAntiseraWorklistQCResults(antiseraWorklistTypingGuid);
			//
			DataTable dtCtrl = new DataTable(ARTIFICIAL.Control);
			dtCtrl.Columns.Add(ARTIFICIAL.Indicator, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.Control, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.ReagentType,typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.VialId, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.IS,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.RT,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.C37,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.AHG,typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.CC, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterp, typeof(string));			
			dtCtrl.Columns.Add(ARTIFICIAL.ControlComment, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.SystemControlInterp, typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlReagentGuid, typeof(Guid));
			dtCtrl.Columns.Add(TABLES.Reagent.ReagentManufacturerName, typeof(string));
			dtCtrl.Columns.Add(TABLES.Reagent.LotExpirationDate, typeof(DateTime));
			dtCtrl.Columns.Add(TABLES.ReactivityPhase.ReactivityPhaseCode, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.IndicatorMessage, typeof(string));
			dtCtrl.Columns.Add(ARTIFICIAL.PartiallyCompleted, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.ISGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.RTGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.C37Guid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGGuid,typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.CCGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterpGuid, typeof(Guid));
			dtCtrl.Columns.Add(ARTIFICIAL.ISRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.RTRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.C37RowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.CCRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.InterpRowVersion,typeof(byte[]));
			dtCtrl.Columns.Add(ARTIFICIAL.ISSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.RTSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.C37Save, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.AHGSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.CCSave, typeof(bool));
			dtCtrl.Columns.Add(ARTIFICIAL.ControlInterpSave, typeof(bool));
			dtCtrl.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtCtrl.Columns.Add(TABLES.RackLot.TestWithId, typeof(int));
			dtCtrl.Columns.Add(ARTIFICIAL.OverrideComment, typeof(string));
			//
			DataRow drPos = dtCtrl.NewRow();
			drPos[ARTIFICIAL.Indicator] = "";
			drPos[ARTIFICIAL.Control] = "POS";
			drPos[ARTIFICIAL.ReagentType] = dtReagents.Rows[1][TABLES.Reagent.ReagentTypeId];
			drPos[TABLES.Reagent.LotNumber] = dtReagents.Rows[1][TABLES.Reagent.LotNumber];
			drPos[ARTIFICIAL.VialId] = "1";
			if (posis != null) drPos[ARTIFICIAL.IS] = posis;
			if (posrt != null) drPos[ARTIFICIAL.RT] = posrt;
			if (pos37 != null) drPos[ARTIFICIAL.C37] = pos37;
			if (posahg != null) drPos[ARTIFICIAL.AHG] = posahg;
			if (poscc != null) drPos[ARTIFICIAL.CC] = poscc;
			if (posinterp != null) drPos[ARTIFICIAL.ControlInterp] = posinterp;
			drPos[ARTIFICIAL.ControlComment] = "Unit Testing";
			drPos[ARTIFICIAL.SystemControlInterp] = "";
			drPos[TABLES.Reagent.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drPos[ARTIFICIAL.ControlReagentGuid] = dtReagents.Rows[1][TABLES.Reagent.ReagentGuid];
			drPos[TABLES.Reagent.ReagentManufacturerName] = dtReagents.Rows[1][TABLES.Reagent.ReagentManufacturerName].ToString();
			drPos[TABLES.Reagent.LotExpirationDate] = dtReagents.Rows[1][TABLES.Reagent.LotExpirationDate];
			drPos[TABLES.ReactivityPhase.ReactivityPhaseCode] = Convert.ToInt32(reactivityPhase).ToString();
			drPos[ARTIFICIAL.IndicatorMessage] = "";
			drPos[ARTIFICIAL.PartiallyCompleted] = true;
			drPos[ARTIFICIAL.ISGuid] = (posis == null) ? Guid.Empty : Guid.NewGuid();
			drPos[ARTIFICIAL.RTGuid] = (posrt == null) ? Guid.Empty : Guid.NewGuid();
			drPos[ARTIFICIAL.C37Guid] = (pos37 == null) ? Guid.Empty : Guid.NewGuid();
			drPos[ARTIFICIAL.AHGGuid] = (posahg == null) ? Guid.Empty : Guid.NewGuid();
			drPos[ARTIFICIAL.CCGuid] = (poscc == null) ? Guid.Empty : Guid.NewGuid();
			drPos[ARTIFICIAL.ControlInterpGuid] = (posinterp == null) ? Guid.Empty : Guid.NewGuid();
			drPos[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			drPos[ARTIFICIAL.ISSave] = (posis != null) ? true : false;
			drPos[ARTIFICIAL.RTSave] = (posrt != null) ? true : false;
			drPos[ARTIFICIAL.C37Save] = (pos37 != null) ? true : false;
			drPos[ARTIFICIAL.AHGSave] = (posahg != null) ? true : true;
			drPos[ARTIFICIAL.CCSave] = (poscc != null) ? true : false;
			drPos[ARTIFICIAL.ControlInterpSave] = (posinterp != null) ? true : false;
			drPos[TABLES.VamcDivision.DivisionCode] = UnitTestConfig.TestDivisionCode;
			drPos[TABLES.RackLot.TestWithId] = reagentTypeId;
			drPos[ARTIFICIAL.OverrideComment] = DBNull.Value;
			//
			dtCtrl.Rows.Add(drPos);
			//
			DataRow drNeg = dtCtrl.NewRow();
			drNeg[ARTIFICIAL.Indicator] = "";
			drNeg[ARTIFICIAL.Control] = "NEG";
			drNeg[ARTIFICIAL.ReagentType] = dtReagents.Rows[2][TABLES.Reagent.ReagentTypeId];
			drNeg[TABLES.Reagent.LotNumber] = dtReagents.Rows[2][TABLES.Reagent.LotNumber];
			drNeg[ARTIFICIAL.VialId] = "0";
			if (negis != null) drNeg[ARTIFICIAL.IS] = negis;
			if (negrt != null) drNeg[ARTIFICIAL.RT] = negrt;
			if (neg37 != null) drNeg[ARTIFICIAL.C37] = neg37;
			if (negahg != null) drNeg[ARTIFICIAL.AHG] = negahg;
			if (negcc != null) drNeg[ARTIFICIAL.CC] = negcc;
			if (neginterp != null) drNeg[ARTIFICIAL.ControlInterp] = neginterp;
			drNeg[ARTIFICIAL.ControlComment] = "Unit Testing";
			drNeg[ARTIFICIAL.SystemControlInterp] = "";
			drNeg[TABLES.Reagent.ReagentGuid] = dtReagents.Rows[0][TABLES.Reagent.ReagentGuid];
			drNeg[ARTIFICIAL.ControlReagentGuid] = dtReagents.Rows[2][TABLES.Reagent.ReagentGuid];
			drNeg[TABLES.Reagent.ReagentManufacturerName] = dtReagents.Rows[2][TABLES.Reagent.ReagentManufacturerName];
			drNeg[TABLES.Reagent.LotExpirationDate] = dtReagents.Rows[2][TABLES.Reagent.LotExpirationDate];
			drNeg[TABLES.ReactivityPhase.ReactivityPhaseCode] = Convert.ToInt32(reactivityPhase).ToString();
			drNeg[ARTIFICIAL.IndicatorMessage] = "";
			drNeg[ARTIFICIAL.PartiallyCompleted] = true;
			drNeg[ARTIFICIAL.ISGuid] = (negis == null) ? Guid.Empty : Guid.NewGuid();
			drNeg[ARTIFICIAL.RTGuid] = (negrt == null) ? Guid.Empty : Guid.NewGuid();
			drNeg[ARTIFICIAL.C37Guid] = (neg37 == null) ? Guid.Empty : Guid.NewGuid();
			drNeg[ARTIFICIAL.AHGGuid] = (negahg == null) ? Guid.Empty : Guid.NewGuid();
			drNeg[ARTIFICIAL.CCGuid] = (negcc == null) ? Guid.Empty : Guid.NewGuid();
			drNeg[ARTIFICIAL.ControlInterpGuid] = (neginterp == null) ? Guid.Empty : Guid.NewGuid();
			drNeg[ARTIFICIAL.ISRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.RTRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.C37RowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.AHGRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.CCRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.InterpRowVersion] = DBNull.Value;
			drNeg[ARTIFICIAL.ISSave] = (negis != null) ? true : false;
			drNeg[ARTIFICIAL.RTSave] = (negrt != null) ? true : false;
			drNeg[ARTIFICIAL.C37Save] = (neg37 != null) ? true : false;
			drNeg[ARTIFICIAL.AHGSave] = (negahg != null) ? true : true;
			drNeg[ARTIFICIAL.CCSave] = (negcc != null) ? true : false;
			drNeg[ARTIFICIAL.ControlInterpSave] = (neginterp != null) ? true : false;
			drNeg[TABLES.VamcDivision.DivisionCode] = UnitTestConfig.TestDivisionCode;
			drNeg[TABLES.RackLot.TestWithId] = reagentTypeId;
			drNeg[ARTIFICIAL.OverrideComment] = DBNull.Value;
			//
			dtCtrl.Rows.Add(drNeg);
			//
			foreach(DataRow result in dtWorklistQCResults.Rows)
			{
				string phase = result[TABLES.RackTest.RackTestResultTypeCode].ToString().Trim();
				//
				if ((bool)result[TABLES.RackLot.ControlCellId])
				{
					drPos[ARTIFICIAL.InterpRowVersion] = result[ARTIFICIAL.RackLotRowVersion];
					drPos[ARTIFICIAL.ControlInterpGuid] = result[TABLES.RackLot.RackLotGuid];
					drPos[TABLES.RackLot.TestWithId] = result[TABLES.RackLot.TestWithId];
					//
					if (phase == ARTIFICIAL.IS)
					{
						drPos[ARTIFICIAL.ISGuid] = result[TABLES.RackTest.RackTestGuid];
						drPos[ARTIFICIAL.ISRowVersion] = result[TABLES.RackTest.RowVersion];
					}
					if (phase == ARTIFICIAL.RT)
					{
						drPos[ARTIFICIAL.RTGuid] = result[TABLES.RackTest.RackTestGuid];
						drPos[ARTIFICIAL.RTRowVersion] = result[TABLES.RackTest.RowVersion];
					}
					if (phase == ARTIFICIAL.C37)
					{
						drPos[ARTIFICIAL.C37Guid] = result[TABLES.RackTest.RackTestGuid];
						drPos[ARTIFICIAL.C37RowVersion] = result[TABLES.RackTest.RowVersion];
					}
					if (phase == ARTIFICIAL.AHG)
					{
						drPos[ARTIFICIAL.AHGGuid] = result[TABLES.RackTest.RackTestGuid];
						drPos[ARTIFICIAL.AHGRowVersion] = result[TABLES.RackTest.RowVersion];
					}
					else if (phase == ARTIFICIAL.CC)
					{
						drPos[ARTIFICIAL.CCGuid] = result[TABLES.RackTest.RackTestGuid];
						drPos[ARTIFICIAL.CCRowVersion] = result[TABLES.RackTest.RowVersion];
					}
				}
				else
				{
					drNeg[ARTIFICIAL.InterpRowVersion] = result[ARTIFICIAL.RackLotRowVersion];
					drNeg[ARTIFICIAL.ControlInterpGuid] = result[TABLES.RackLot.RackLotGuid];
					drNeg[TABLES.RackLot.TestWithId] = result[TABLES.RackLot.TestWithId];
					//
					if (phase == ARTIFICIAL.IS)
					{
						drNeg[ARTIFICIAL.ISGuid] = result[TABLES.RackTest.RackTestGuid];
						drNeg[ARTIFICIAL.ISRowVersion] = result[TABLES.RackTest.RowVersion];
					}
					if (phase == ARTIFICIAL.RT)
					{
						drNeg[ARTIFICIAL.RTGuid] = result[TABLES.RackTest.RackTestGuid];
						drNeg[ARTIFICIAL.RTRowVersion] = result[TABLES.RackTest.RowVersion];
					}
					if (phase == ARTIFICIAL.C37)
					{
						drNeg[ARTIFICIAL.C37Guid] = result[TABLES.RackTest.RackTestGuid];
						drNeg[ARTIFICIAL.C37RowVersion] = result[TABLES.RackTest.RowVersion];
					}
					if (phase == ARTIFICIAL.AHG)
					{
						drNeg[ARTIFICIAL.AHGGuid] = result[TABLES.RackTest.RackTestGuid];
						drNeg[ARTIFICIAL.AHGRowVersion] = result[TABLES.RackTest.RowVersion];
					}
					else if (phase == ARTIFICIAL.CC)
					{
						drNeg[ARTIFICIAL.CCGuid] = result[TABLES.RackTest.RackTestGuid];
						drNeg[ARTIFICIAL.CCRowVersion] = result[TABLES.RackTest.RowVersion];
					}
				}
				//
			}
			//
			//Now save test results
			ArrayList workloadProcessIds = new ArrayList(1);
			workloadProcessIds.Add(Common.WorkloadProcessID.Unknown);
			BOL.BloodUnitTest.SaveAntigenTypingBloodUnitTests(antiseraWorklistTypingGuid,tmpAW,dtAG,dtCtrl, Convert.ToInt32(Common.ReactivityPhase.AHGandCC).ToString(), Common.UpdateFunction.UnitTests, workloadProcessIds, buGuids, true);  
		}

		#endregion
	}
}
#endif
